
{*******************************************************}
{                                                       }
{       Ukadanka - Delphi                              }
{       Wykorzystanie komponentu GlBox i OpenGL         }
{                                                       }
{       autor: Waldemara Pokuta - 2003                  }
{                                                       }
{*******************************************************}

unit Unit1;

interface

uses
  Windows, Forms, OpenGl, GLBox, Messages, Controls, ExtCtrls, Classes;

type
  TForm1 = class(TForm)
    GL: TGLBox;
    procedure UstalRozmiar;
    procedure glSetupRC(Sender: TObject);
    procedure glRender(Sender: TObject);
    procedure glResize(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

  procedure Szescian;

implementation

{$R *.DFM}

procedure TForm1.UstalRozmiar;
var
  w, h: integer;
begin
  // Ustalenie widoku perspektywicznego
  w := gl.Width;
  h := gl.Height;
  glViewport(0, 0, w, h);
  if h = 0 then h := 1;
  glMatrixMode(GL_PROJECTION);
  glLoadIdentity;
  gluPerspective(60, w/h, 1, 400);
  glMatrixMode(GL_MODELVIEW);
end;

procedure TForm1.glSetupRC(Sender: TObject);
begin
  // Wartoci pocztkowe
  glClearColor(0, 0, 0, 1);
  UstalRozmiar;
end;

procedure TForm1.glRender(Sender: TObject);
begin
  glClear(GL_COLOR_BUFFER_BIT or GL_DEPTH_BUFFER_BIT);
  glLoadIdentity;   // Przeksztacenie tosamociowe
  // Ustawienie kamery
  gluLookAt(0,0,200, 0, 0, 0, 0, 1, 0);
  // Rysowanie sceny
  glScalef(15, 15, 15);
  szescian;
end;

procedure TForm1.glResize(Sender: TObject);
begin
  UstalRozmiar;
end;

procedure Szescian;
var i: integer;
begin
  glPushMatrix;
  for i:=0 to 5 do begin
    glBegin(GL_QUADS);
      glNormal3f( 0.0, 0.0, 1.0);
      glVertex3f( 0.5, 0.5, 0.5);
      glVertex3f(-0.5, 0.5, 0.5);
      glVertex3f(-0.5,-0.5, 0.5);
      glVertex3f( 0.5,-0.5, 0.5);
    glEnd;
    if odd(i) then glRotatef(90, 1, 0, 0) else glRotatef(90, 0, 1, 0);
  end;
  glPopMatrix;
end;

end.
