{*******************************************************}
{                                                       }
{       Dynamika w OpenGL - Delphi                      }
{       Wykorzystanie komponentu GlBox i OpenGL         }
{                                                       }
{       autor: Waldemara Pokuta - 2003                  }
{                                                       }
{*******************************************************}

unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  GLBox, OpenGL, ExtCtrls;

type
  TForm1 = class(TForm)
    GL: TGLBox;
    Timer1: TTimer;
    procedure UstalRozmiar;
    procedure GLSetupRC(Sender: TObject);
    procedure GLResize(Sender: TObject);
    procedure GLRender(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  kw: gluQuadricObj;
  procedure powierzchnia;
  procedure kula(t: integer);
  procedure walec;
  procedure stozek;
  procedure dwastozki;
  procedure UstawOswietlenie;
implementation

{$R *.DFM}

procedure TForm1.UstalRozmiar;
var
  w, h: integer;
begin
  // Ustalenie widoku perspektywicznego
  w := gl.Width;
  h := gl.Height;
  if h = 0 then h := 1;
  glMatrixMode(GL_PROJECTION);
  glLoadIdentity;
  gluPerspective(80, w/h, 1, 600);
  glMatrixMode(GL_MODELVIEW);
end;

procedure UstawOswietlenie;
const
  ambient : TGLArrayf4 = (0.3, 0.3, 0.3, 1.0);
  swiatla : array[0..3] of record
    dif, spec, pos: TGLArrayf4
  end =
  ((dif:( 0.9, 0.9, 0.1, 1.0); spec:( 0.9, 0.9, 0.1, 1.0); pos:(-200,-100,   0, 1.0)),
   (dif:( 0.1, 0.9, 0.9, 1.0); spec:( 0.9, 0.9, 0.9, 1.0); pos:(   0, 150,  50, 1.0)),
   (dif:( 0.9, 0.1, 0.9, 1.0); spec:( 0.9, 0.1, 0.9, 1.0); pos:( 200,   0,-200, 1.0)),
   (dif:( 0.5, 0.5, 0.9, 1.0); spec:( 0.5, 0.5, 0.9, 1.0); pos:(   0, 100, 200, 1.0)));
var
  i: integer;
begin
  glLightModelfv(GL_LIGHT_MODEL_AMBIENT, @ambient);
  for i := 0 to 3 do begin
    glLightfv(GL_LIGHT0+i,  GL_DIFFUSE,  @swiatla[i].dif);
    glLightfv(GL_LIGHT0+i, GL_SPECULAR, @swiatla[i].spec);
    glLightfv(GL_LIGHT0+i, GL_POSITION,  @swiatla[i].pos);
    glEnable (GL_LIGHT0+i);
  end;
end;

procedure TForm1.GLResize(Sender: TObject);
begin
  UstalRozmiar;
end;

procedure TForm1.GLSetupRC(Sender: TObject);
const
  amb_dif: TGLArrayf4 = (0.8, 0.8, 0.8, 0.2);
  spec   : TGLArrayf4 = (0.5, 0.5, 0.5, 0.2);
  emis   : TGLArrayf4 = (0.0, 0.0, 0.0, 0.2);
begin
  // Wartoci pocztkowe
  glClearColor(0.0, 0.0, 0.0, 1.0);
  UstalRozmiar;
  glEnable(GL_LIGHTING);
  glEnable(GL_DEPTH_TEST);
  glEnable(GL_COLOR_MATERIAL);
  glEnable(GL_NORMALIZE);
  // Materia figur
  glMaterialfv(GL_FRONT_AND_BACK, GL_AMBIENT_AND_DIFFUSE, @amb_dif);
  glMaterialfv(GL_FRONT_AND_BACK,            GL_SPECULAR,    @spec);
  glMaterialf (GL_FRONT_AND_BACK,           GL_SHININESS,       80);
  glMaterialfv(GL_FRONT_AND_BACK,            GL_EMISSION,    @emis);
  // Kwadryki
  kw := gluNewQuadric;
  gluQuadricDrawStyle(kw, GLU_FILL);
  gluQuadricNormals(kw, GLU_SMOOTH);
  gluQuadricOrientation(kw, GLU_OUTSIDE);
  Timer1.Enabled := TRUE;
end;

procedure powierzchnia;
var
  i, j: integer;
begin
  glColor3f(0.0, 0.5, 0.0);
  glBegin(GL_QUADS);
  for i := -60 to 59 do
    for j := -25 to 24 do begin
      glVertex3f(    i*2, -20,     j*2);
      glVertex3f(    i*2, -20, (j+1)*2);
      glVertex3f((i+1)*2, -20, (j+1)*2);
      glVertex3f((i+1)*2, -20,     j*2);
    end;
  glEnd;
end;

procedure kula(t: integer);
begin
  glColor3f(1.0, 0.0, 0.0);
  glTranslatef(70, 0, 0);
  glPushMatrix;
  glTranslatef(0, (sin(t/10)+1)*20, 0);
  gluSphere(kw, 20, 50, 50);
  glPopMatrix;
end;

procedure walec;
begin
  glColor3f(0.0, 0.0, 1.0);
  glTranslatef(-50, 0, 0);
  glPushMatrix;
  glTranslatef(0, 20, 0);
  glRotatef(90, 1, 0, 0);
  gluCylinder(kw, 18, 18, 40, 50, 50);
  glPopMatrix;
end;

procedure stozek;
begin
  glColor3f(1.0, 1.0, 0.0);
  glTranslatef(-50, 0, 0);
  glPushMatrix;
  glTranslatef(0,-20, 0);
  glRotatef(-90, 1, 0, 0);
  gluCylinder(kw, 20, 0, 40, 50, 50);
  glPopMatrix;
end;

procedure dwastozki;

begin
  glColor3f(0, 0.5, 0.5);
  glTranslatef(-50, 0, 0);
  glPushMatrix;
  glRotatef(90, 1, 0, 0);
  gluCylinder(kw, 20, 0, 20, 50, 50);
  glTranslatef(0, 0, -20);
  gluCylinder(kw, 0, 20, 20, 50, 50);
  glPopMatrix;
end;

procedure TForm1.GLRender(Sender: TObject);
const
  t: integer = 0;
begin
  glClear(GL_COLOR_BUFFER_BIT or GL_DEPTH_BUFFER_BIT);
  glLoadIdentity;
  gluLookAt(0, 20, 160, 0, 0, 0, 0, 1, 0);
  UstawOswietlenie;
  // Rysowanie sceny
  powierzchnia;
  kula(t);
  walec;
  stozek;
  dwastozki;
  t := t+1;
end;

procedure TForm1.Timer1Timer(Sender: TObject);
begin
  gl.Invalidate;
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  gluDeleteQuadric(kw);
end;

end.
