{*******************************************************}
{                                                       }
{       Kamera OpenGL w Delphi                          }
{       Wykorzystanie komponentu GlBox i OpenGL         }
{                                                       }
{       autor: Waldemara Pokuta - 2003                  }
{                                                       }
{*******************************************************}

unit Unit1;

interface

uses
  Windows, Forms, OpenGl, GLBox, Messages, Controls, ExtCtrls, Classes;

type
  TForm1 = class(TForm)
    GL: TGLBox;
    procedure UstawOswietlenie;
    procedure UstalRozmiar;
    procedure GLSetupRC(Sender: TObject);
    procedure GLRender(Sender: TObject);
    procedure GLResize(Sender: TObject);
    procedure GLKeyPress(Sender: TObject; var Key: Char);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  kw1, kw2, kw3, kw4: GLUquadricObj;
  kam: integer;
implementation

{$R *.DFM}

procedure TForm1.UstawOswietlenie;
const
  spec:TGLArrayf4 = ( 0.7, 1.0, 1.0, 1.0);
  pos: TGLArrayf4 = (-150, -50,  50, 1.0);
begin
  glLightfv(GL_LIGHT0, GL_SPECULAR, @spec);
  glLightfv(GL_LIGHT0, GL_POSITION, @pos );
  glEnable (GL_LIGHT0);
end;

procedure TForm1.UstalRozmiar;
var
  w, h: integer;
begin
  // Ustalenie widoku perspektywicznego
  w := gl.Width;
  h := gl.Height;
  if h = 0 then h := 1;
  glMatrixMode(GL_PROJECTION);
  glLoadIdentity;
  gluPerspective(60, w/h, 1, 400);
  glMatrixMode(GL_MODELVIEW);
end;

procedure TForm1.GLSetupRC(Sender: TObject);
const
  amb_dif: TGLArrayf4 = (1.0, 1.0, 1.0, 1);
  spec   : TGLArrayf4 = (1.0, 1.0, 1.0, 1);
  emis   : TGLArrayf4 = (0.1, 0.1, 0.1, 1);
begin
  // Wartoci pocztkowe
  glClearColor(0, 0, 0, 1);
  UstalRozmiar;
  glEnable(GL_LIGHTING);
  glEnable(GL_DEPTH_TEST);
  // Inicjowanie kwadryk
  // punkty
  kw1 := gluNewQuadric;
  gluQuadricDrawStyle(kw1, GLU_POINT);
  // linie
  kw2 := gluNewQuadric;
  gluQuadricDrawStyle(kw2, GLU_LINE);
  // wypenione wielokty - paskie cieniowanie
  kw3 := gluNewQuadric;
  gluQuadricDrawStyle(kw3, GLU_FILL);
  gluQuadricNormals(  kw3, GLU_FLAT);
  // wypenione wielokty - gadkie cieniowanie
  kw4 := gluNewQuadric;
  gluQuadricDrawStyle(  kw4, GLU_FILL);
  gluQuadricNormals(    kw4, GLU_SMOOTH);
  gluQuadricOrientation(kw4, GLU_OUTSIDE);
end;

procedure TForm1.GLRender(Sender: TObject);
begin
  glClear(GL_COLOR_BUFFER_BIT or GL_DEPTH_BUFFER_BIT);
  glLoadIdentity;   // Przeksztacenie tosamociowe
  // Owietlenie
  UstawOswietlenie;
  // kamera
  case kam of
    1: gluLookAt(15,  40,-50, 0, 40,-100,   0,   1, 0);
  end;
  // Rysowanie sceny
  // sfera
  glTranslatef(20, 50,-150);
  glRotatef(-10, 1, 0.3, 0);
  gluSphere(kw1, 30, 50, 50);
  // dysk
  glTranslatef(0,-30, 0);
  glRotatef(90, 1, 0, 0);
  gluDisk(kw2, 15, 30, 30, 10);
  // cylinder
  glRotatef(-90, 1, 0, 0);
  glTranslatef(0, 0, 0);
  glRotatef(90, 1, 0, 0);
  gluCylinder(kw3, 20, 20, 60, 20, 20);
  // city stoek
  glTranslatef(0, 0, 60);
  gluCylinder(kw4, 20, 30, 10, 20, 20);
end;

procedure TForm1.GLResize(Sender: TObject);
begin
  UstalRozmiar;
end;

procedure TForm1.GLKeyPress(Sender: TObject; var Key: Char);
begin
  case key of
    '1': kam := 1;
  end;
  Gl.Invalidate;
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  gluDeleteQuadric(kw1);
  gluDeleteQuadric(kw2);
  gluDeleteQuadric(kw3);
  gluDeleteQuadric(kw4);
end;

end.
