{*******************************************************}
{                                                       }
{       Podstawy OpenGL w Delphi                        }
{       Wykorzystanie komponentu GlBox i OpenGL         }
{                                                       }
{       autor: Waldemara Pokuta - 2003                  }
{                                                       }
{*******************************************************}

unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  GLBox, OpenGL;

type
  TForm1 = class(TForm)
    GLBox1: TGLBox;
    procedure GLBox1Render(Sender: TObject);
    procedure GLBox1Resize(Sender: TObject);
    procedure GLBox1SetupRC(Sender: TObject);
    procedure GLBox1KeyPress(Sender: TObject; var Key: Char);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.GLBox1SetupRC(Sender: TObject);
begin
  // Wartoci pocztkowe
  glClearColor(0, 0, 0, 1);
  glEnable(GL_DEPTH_TEST);
  GLBox1Resize(nil);
end;

procedure TForm1.GLBox1Resize(Sender: TObject);
var
  r: real;
  w, h: integer;
begin
  r := 120;
  w := GLBox1.Width;
  h := GLBox1.Height;
  if h = 0 then h := 1;
  glMatrixMode(GL_PROJECTION);
  glLoadIdentity;
  if w<=h then
    glOrtho(-r, r, -r*h/w, r*h/w, -r, r)
  else
    glOrtho(-r*w/h, r*w/h, -r, r, -r, r);
  glMatrixMode(GL_MODELVIEW);
end;

procedure TForm1.GLBox1Render(Sender: TObject);
var
  x, y, z, kat: real;
  i: integer;
begin
  glClear(GL_COLOR_BUFFER_BIT or GL_DEPTH_BUFFER_BIT);
  // punkt centralny
  glColor3f(1, 1, 1);
  glBegin(GL_POINTS);
    glVertex3f(0, 0, 0);
  glEnd;
  // strefa mocy
  glPointSize(3);
  glBegin(GL_POINTS);
    z := 40;
    kat := 0;
    while kat<=2*PI*3 do begin
      x := 70*sin(kat);
      y := 70*cos(kat);
      glVertex3f(x, y, z);
      z := z+0.1;
      kat := kat+0.2;
    end;
  glEnd;
  glPointSize(1);
  // jonizator nadprzestrzenny
  glEnable(GL_LINE_STIPPLE);
  glLineStipple(1, 255);
  glLineWidth(2);
  glBegin(GL_LINES);
    kat := 0;
    while kat<=(2*PI) do begin
      x := 50*sin(kat);
      y := 50*cos(kat);
      glVertex3f(x, y, -20);
      glVertex3f(0, 0, -80);
      kat := kat+0.1*PI;
    end;
  glEnd;
  glDisable(GL_LINE_STIPPLE);
  // baterie soneczne
  glColor3f(1, 0, 1);
  glEnable(GL_CULL_FACE);
  glBegin(GL_TRIANGLES);
    // pierwszy trjkt
    glVertex3f(  20,   0,  70);
    glVertex3f( 100,   0,  50);
    glVertex3f(  50,  80,  50);
    // drugi trjkt
    glVertex3f( -10,  16,  70);
    glVertex3f( -50,  80,  50);
    glVertex3f(-100,   0,  50);
    // trzeci trjkt
    glVertex3f( -10, -16,  70);
    glVertex3f( -50, -80,  50);
    glVertex3f(  50, -80,  50);
  glEnd;
  glDisable(GL_CULL_FACE);
  // generatory pola siowego
  glPolygonMode(GL_BACK, GL_LINE);
  glColor3f(1, 1, 0);
  glBegin(GL_QUADS);
    kat := 0;
    while kat<=(2*PI) do begin
      x := sin(kat);
      y := cos(kat);
      glVertex3f(x*50, y*50, 40);
      glVertex3f(x*50, y*50, 10);
      glVertex3f(x*70, y*70, 10);
      glVertex3f(x*70, y*70, 40);
      kat := kat+0.1*PI;
    end;
  glEnd;
  glPolygonMode(GL_BACK, GL_FILL);
  // korpus
  glBegin(GL_TRIANGLE_STRIP);
    for i := -1 to 20 do begin
      x := 50*sin(i*0.1*PI);
      y := 50*cos(i*0.1*PI);
      if odd(i) then z := -10 else z := 10;
      if odd(i) then glColor3f(0, 1, 1) else glColor3f(1, 0, 0);
      glVertex3f(x, y, z);
    end;
  glEnd;
end;

procedure TForm1.GLBox1KeyPress(Sender: TObject; var Key: Char);
var x, y, z: real;
begin
  GLBox1.MakeCurrent;
  x := 0;
  y := 0;
  z := 0;
  case key of
  #27: close;
  'q','Q': x:=1;
  'a','A': x:=-1;
  'w','W': y:=1;
  's','S': y:=-1;
  'e','E': z:=1;
  'd','D': z:=-1;
  end;
  if (x<>0) or (y<>0) or (z<>0) then glRotatef(5, x, y, z);
  GlBox1.Invalidate;
  GLBox1.MakeNotCurrent;
end;

end.
