#include  <stdio.h>
#include  <string.h>

#define   NUMERIC   1         /* sortowanie numeryczne */
#define   DECR      2         /* sortowanie od najwikszego do najmniejszego */
#define   LINES     100       /* dopuszczalna liczba wierszy do sortowania */

int numcmp(char *, char *);
int readlines(char *lineptr[], int maxlines);
void qsort(char *v[], int left, int right,
           int (*comp)(void *, void *));
void writelines(char *lineptr[], int nlines, int decr);

static char option = 0;

/* sortowanie wierszy strumienia danych wejciowych */
main(int argc, char *argv[])
{
    char *lineptr[LINES];        /* wskaniki do wierszy tekstu */
    int nlines;                  /* liczba odczytanych wierszy */
    int c, rc = 0;

    while (--argc > 0 && (*++argv)[0] == '-')
        while (c = *++argv[0])
            switch (c) {
            case 'n' :           /* sortowanie numeryczne */
                option |= NUMERIC;
                break;
            case 'r' :           /* sortowanie malejco */
                option |= DECR;
                break;
            default:
                printf("sort: illegal option %c\n", c);
                argc = 1;
                rc = -1;
                break;
            }
    if (argc)
        printf("Usage: sort nr \n");
    else
        if ((nlines = readlines(lineptr, LINES)) > 0) {
            if (option & NUMERIC)
                qsort((void **) lineptr, 0, nlines-1,
                     (int (*) (void *, void *)) numcmp);
            else
                qsort((void **) lineptr, 0, nlines-1,
                     (int (*) (void *, void *)) strcmp);
            writelines(lineptr, nlines, option & DECR);
        } else {
            printf("input too big to sort\n");
            rc = -1;
        }
    return rc;
}

/* writelines: wypisuje wiersze wyjciowe */
void writelines(char *lineptr[], int nlines, int decr)
{
    int i;
    
    if (decr)                 /* malejco */
        for (i = nlines-1; i >= 0; i--)
            printf("%s\n", lineptr[i]);
    else
        for (i = 0; i < nlines; i++)
            printf("%s\n", lineptr[i]);
}
