#include <stdio.h>
#define MAXLINE 1000 /* dopuszczalna dugo wiersza danych wejciowych */

int getline(char line[], int maxline);
void copy(char to[], char from[]);

/* wypisywanie najduszego wiersza danych wejciowych */
main()
{
    int len;               /* dugo biecego wiersza */
    int max;               /* najwiksza znana dugo */
    char line[MAXLINE];    /* biecy wiersz wejcia */
    char longest[MAXLINE]; /* najduszy wiersz */

    max = 0;
    while ((len = getline(line, MAXLINE)) > 0)
        printf("%d, %s", len, line);
        if (len > max) {
            max = len;
            copy(longest, line);
        }
    if (max > 0) /* dane wejciowe zawieray co najmniej jeden wiersz */
        printf("%s", longest);
    return 0;
}

/* getline: pobiera wiersz do tablicy s, zwraca dugo */
int getline(char s[], int lim)
{
    int c, i, j;

    j = 0;
    for (i = 0; (c = getchar()) != EOF && c != '\n'; ++i)
        if (i < lim-2) {
            s[j] = c;       /* dugo w dopuszczalnych granicach */
            ++j;
        }
    if (c == '\n') {
        s[j] = c;
        ++j;
        ++i;
    }
    s[j] = '\0';
    return i;
}

/* copy: kopiuje from do to, zakada wystarczajcy rozmiar to */
void copy(char to[], char from[])
{
    int i;

    i = 0;
    while ((to[i] = from[i]) != '\0')
        ++i;
}
