#include  "syscalls.h"

/* fseek: seek dla wskanika pliku */
int fseek(FILE *fp, long offset, int origin)
{
    unsigned nc;                 /* liczba znakw do zapisania */
    long rc = 0;                 /* kod wyjciowy */

    if (fp->flag & _READ) {
        if (origin == 1)         /* od biecej pozycji? */
            offset -= fp->cnt;   /* zapamitaj znaki w buforze */
        rc = lseek(fp->fd, offset, origin);
        fp->cnt = 0;
    } else if (fp->flag & _WRITE) {
        if ((nc = fp->ptr  fp->base) > 0)
            if (write(fp->fd, fp->base, nc) != nc)
                rc = -1;
        if (rc != -1)             /* brak bdw? */
            rc = lseek(fp->fd, offset, origin);
    }
    return (rc == -1) ? -1 : 0;
}
