#include  <stdio.h>
#include  <math.h>      /* dla atof() */

#define   MAXOP   100   /* dopuszczalny rozmiar operandu lub operatora */
#define   NUMBER  '0'   /* sygna, e pobrano liczb */

int getop(char []);
void ungets(char []);
void push(double);
double pop(void);

/* kalkulator z odwrotn notacj polsk; dane pobierane z wiersza polece */
main(int argc, char *argv[])
{
    char s[MAXOP];
    double op2;
    
    while (--argc > 0) {
        ungets(" ");            /* zapisz do danych wejciowych zakoczenie argumentu */
        ungets(*++argv);        /* zapisz do danych wejciowych argument */
        switch (getop(s)) {
        case NUMBER:
            push(atof(s));
            break;
        case '+':
            push(pop() + pop());
            break;
        case '*':
            push(pop() * pop());
            break;
        case '-':
            op2 = pop();
            push(pop() - op2);
            break;
        case '/':
            op2 = pop();
            if (op2 != 0.0)
                push(pop() / op2);
            else
                printf("error: zero divisor\n");
            break;
        default:
            printf("error: unknown command %s\n", s);
            argc = 1;
            break;
        }
    }
    printf("\t%.8g\n", pop());
    return 0;
}
