#include <stdio.h>

void rcomment(int c);
void in_comment(void);
void echo_quote(int c);

/* usuwanie wszystkich komentarzy z poprawnego programu w jzyku C */
main()
{
    int c, d;

    while ((c = getchar()) != EOF)
        rcomment(c);
    return 0;
}

/* rcomment: odczytuje znak programu, usuwa komentarze */
void rcomment(int c)
{
    int d;

    if (c == '/')
        if ((d = getchar()) == '*')
            in_comment();            /* pocztek komentarza */
        else if (d == '/') {
            putchar(c);              /* nastpny ukonik */
            rcomment(d);
        } else {
            putchar(c);              /* nie komentarz */
            putchar(d);
        }
    else if (c == '\'' || c == '"')
        echo_quote(c);               /* pocztek cudzysowu */
    else
        putchar(c);                  /* nie komentarz */
}

/* in_comment: wewntrz komentarza */
void in_comment(void)
{
    int c, d;

    c = getchar();                   /* poprzedni znak */
    d = getchar();                   /* biecy znak */
    while (c != '*' || d != '/') {   /* szukaj koca */
        c = d;
        d = getchar();
    }
}

/* echo_quote: wypisuje bez zmian znaki w cudzysowie */
void echo_quote(int c)
{
    int d;

    putchar(c);
    while ((d = getchar()) != c) {   /* szukaj koca */
        putchar(d);
        if (d == '\\')
            putchar(getchar());      /* ignoruj sekwencje sterujce */
    }
    putchar(d);
}
