#include  "syscalls.h"

#define   MAXBYTES   (unsigned) 10240;

static unsigned maxalloc;      /* maksymalna liczba alokowanych jednostek */
static Header base;            /* pocztkowa pusta lista */
static Header *freep = NULL;   /* pocztek listy wolnych blokw */

/* malloc: uniwersalny mechanizm alokacji pamici */
void *malloc(unsigned nbytes)
{
    Header *p, *prevp;
    static Header *moreroce(unsigned);
    unsigned nunits;

    if (nbytes > MAXBYTES) {          /* nie wicej ni MAXBYTES */
        fprintf(stderr,
                "alloc: can't allocate more then %u bytes\n",
                      MAXBYTES);
             return NULL;
         }
    nunits = (nbytes + sizeof(Header) - 1) / sizeof(header) + 1;

    /* . . . */                       /* jak w podrczniku K&R */
}

#define NALLOC 1024     /* minimalna liczba pobieranych od systemu jednostek */

/* morecore: danie przydzielenia przez system wikszej iloci pamici */
static Header *morecore(unsigned nu)
{
    char *cp, *sbrk(int);
    Header *up;
    
    if (nu < NALLOC)
        nu = NALLOC;
    cp = sbrk(nu * sizeof(Header));
    if (cp == (char *) -1)            /* brak miejsca */
        return NULL;
    up = (Header *) cp;
    up->s.size = nu;
    maxalloc = (up->s.size > maxalloc) ? up->s.size : maxalloc;
    free((void *)(up+1));
    return freep;
}

/* free: docza blok ap do listy wolnych blokw */
void free(void *ap)
{
    Header *bp, *p;
    
    bp = (Header *)ap - 1;              /* nagwek bloku */
    if (bp->s.size == 0 || bp->s.size > maxalloc) {
        fprintf(stderr, "free: can't free %u units\n",
                bp->s.size);
        return;
    }
    for (p = freep; !(bp > p && bp < p->s.ptr); p = p->s.ptr)

    /* . . . */                       /* jak w podrczniku K&R */
}
