#include  <stdio.h>
#include  <stdarg.h>
#include  <ctype.h>

#define   LOCALFMT   100

/* minscanf: minimalna wersja scanf ze zmienn list argumentw */
void minscanf(char *fmt, ...)
{
    va_list ap;         /* wskazuje kolejne nienazwane argumenty */
    char *p, *sval;
    char localfmt[LOCALFMT];
    int c, i, *ival;
    unsigned *uval;
    double *dval;

    i = 0;              /* indeks tablicy localfmt */
    va_start(ap, fmt);  /* przypisuje ap lokalizacj pierwszego nienazwanego argumentu */
    for (p = fmt; *p; p++) {
        if (*p != '%') {
            localfmt[i++] = *p;         /* zbieranie znakw */
            continue;
        }
        localfmt[i++] = '%';            /* pocztek formatowania lokalnego */
        while (*(p+1) && !isalpha(*(p+1)))
            localfmt[i++] = *++p;       /* zbieranie znakw */
        localfmt[i++] = *(p+1);         /* litera okrelajca typ */
        localfmt[i]   = '\0';
        switch (*++p) {                 /* litera okrelajca typ */
        case 'd':
        case 'i':
            ival = va_arg(ap, int);
            scanf(localfmt, ival);
            break;
        case 'x':
        case 'X':
        case 'u':
        case 'o':
            uval = va_arg(ap, unsigned *);
            scanf(localfmt, uval);
            break;
        case 'f':
            dval = va_arg(ap, double *);
            scanf(localfmt, dval);
            break;
        case 's':
            sval = va_arg(ap, char *);
            scanf(localfmt, sval);
            break;
        default:
            scanf(localfmt);
            break;
        }
        i = 0;                          /* zeruj indeks */
    }
    va_end(ap);    /* sprztanie */
}
