#include  <stdio.h>
#include  <string.h>
#include  <stdlib.h>
#include  <ctype.h>

#define   MAXTOKEN  100

enum { NAME, PARENS, BRACKETS };
enum { NO, YES };

void dcl(void);
void errmsg(char *);
void dclspec(void);
int  typespec(void);
int  typequal(void);
int  compare(char **, char **);
int  gettoken(void);
extern int tokentype;            /* typ ostatniego leksemu */
extern char token[];             /* ostatni cig leksemu */
extern char name[];              /* nazwa identyfikatora */
extern char datatype[];          /* typ danych  char, int itp. */
extern char out[];
extern int prevtoken;

/* parmdcl: analizuje skadni deklaratora parametru */
void parmdcl(void)
{
    do {
        dclspec();
    } while (tokentype == ',');
    if (tokentype != ')')
        errmsg("missing ) in parameter declaration\n");
}

/* dclspec: specyfikacja deklaracji */
void dclspec(void)
{
    char temp[MAXTOKEN];

    temp[0] = '\0';
    gettoken();
    do {
        if (tokentype != NAME) {
            prevtoken = YES;
            dcl();
        } else if (typespec() == YES) {
            strcat(temp, " ");
            strcat(temp, token);
            gettoken();
        } else if (typequal() == YES) {
            strcat(temp, " ");
            strcat(temp, token);
            gettoken();
        } else
            errmsg("unknown type in parameter list\n");
    } while (tokentype != ',' && tokentype != ')');
    strcat(out, temp);
    if (tokentype == ',')
        strcat(out, ",");
}

/* typespec: zwraca YES, jeeli leksem jest specyfikatorem typu */
int typespec(void)
{
    static char *types[] = {
              "char",
              "int",
              "void"
    };
    char *pt = token;

    if (bsearch(&pt, types, sizeof(types)/sizeof(char *),
         sizeof(char *), compare) == NULL)
        return NO;
    else
        return YES;
}

/* typequal: zwraca YES, jeeli leksem jest kwalifikatorem typu */
int typequal(void)
{
    static char *typeq[] = {
              "const",
              "volatile"
    };
    char *pt = token;

    if (bsearch(&pt, typeq, sizeof(typeq)/sizeof(char *),
         sizeof(char *), compare) == NULL)
        return NO;
    else
        return YES;
}

/* compare: porwnuje dwa cigi dla bsearch */
int compare(char **s, char **t)
{
    return strcmp(*s, *t);
}
