#include  <stdio.h>
#include  <ctype.h>

#define   NUMERIC   1         /* sortowanie numeryczne */
#define   DECR      2         /* sortowanie od najwikszego do najmniejszego */
#define   FOLD      4         /* brak rozrniania wielkoci liter */
#define   DIR       8         /* kolejno ksiki telefonicznej */
#define   LINES     100       /* dopuszczalna liczba wierszy do sortowania */

int charcmp(char *, char *);
int numcmp(char *, char *);
int readlines(char *lineptr[], int maxlines);
void qsort(char *v[], int left, int right,
           int (*comp)(void *, void *));
void writelines(char *lineptr[], int nlines, int order);

static char option = 0;

/* sortowanie wierszy strumienia danych wejciowych */
main(int argc, char *argv[])
{
    char *lineptr[LINES];        /* wskaniki do wierszy tekstu */
    int nlines;                  /* liczba odczytanych wierszy */
    int c, rc = 0;

    while (--argc > 0 && (*++argv)[0] == '-')
        while (c = *++argv[0])
            switch (c) {
            case 'd' :           /* kolejno ksiki telefonicznej */
                option |= DIR;
                break;
            case 'f' :           /* brak rozrniania wielkoci liter */
                option |= FOLD;
                break;
            case 'n' :           /* sortowanie numeryczne */
                option |= NUMERIC;
                break;
            case 'r' :           /* sortowanie malejco */
                option |= DECR;
                break;
            default:
                printf("sort: illegal option %c\n", c);
                argc = 1;
                rc = -1;
                break;
            }
    if (argc)
        printf("Usage: sort dfnr \n");
    else
        if ((nlines = readlines(lineptr, LINES)) > 0) {
            if (option & NUMERIC)
                qsort((void **) lineptr, 0, nlines-1,
                     (int (*) (void *, void *)) numcmp);
            else
                qsort((void **) lineptr, 0, nlines-1,
                     (int (*) (void *, void *)) charcmp);
            writelines(lineptr, nlines, option & DECR);
        } else {
            printf("input too big to sort\n");
            rc = -1;
        }
    return rc;
}

/* charcmp: zwraca < 0, jeeli s < t, 0, jeeli s == t, lub > 0, jeeli s > t */
int charcmp(char *s, char *t)
{
    char a, b;
    int fold = (option & FOLD) ? 1 : 0;
    int dir = (option & DIR) ? 1 : 0;

    do {
        if (dir) {
            while (!isalnum(*s) && *s != ' ' && *s != '\0')
                s++;
            while (!isalnum(*t) && *t != ' ' && *t != '\0')
                t++;
        }
        a = fold ? tolower(*s) : *s;
        s++;
        b = fold ? tolower(*t) : *t;
        t++;
        if (a == b && a == '\0')
            return 0;
    while (a == b);
    return a - b;
}
