#include  <stdlib.h>

#define   MAXLINE  100          /* dopuszczalna dugo wiersza */
#define   TABINC   8            /* szeroko tabulatora */
#define   YES      1
#define   NO       0

/* esettab: inicjalizuje tablic pozycji tabulacji */
void esettab(int argc, char *argv[], char *tab);
{
    int i, inc, pos;
 
    if (argc <= 1)             /* domylne pozycje tabulacji */
        for (i = 1; i <= MAXLINE; i++)
            if (i % TABINC == 0)
                tab[i] = YES;
            else
                tab[i] = NO;
    else if (argc == 3 &&      /* odstpy okrelone przez uytkownika */
                 *argv[1] == '-' && *argv[2] == '+') {
        pos = atoi(&(*++argv)[1]);
        inc = atoi(&(*++argv)[1]);
        for (i = 1; i <= MAXLINE; i++)
            if (i != pos)
                tab[i] = NO;
            else {
                tab[i] = YES;
                pos += inc;
            }
    } else {                   /* pozycje tabulacji okrelone przez uytkownika */
        for (i = 1; i <= MAXLINE; i++)
            tab[i] = NO;       /* usu wszystkie pozycje tabulacji */
        while (--argc > 0) {   /* przegldanie listy argumentw */
            pos = atoi(*++argv);
            if (pos > 0 && pos <= MAXLINE)
                tab[pos] = YES;
        }
    }
}
