/* rightrot: przesunicie cykliczne x o n pozycji w prawo */
unsigned rightrot(unsigned x, int n)
{
    int wordlength(void);
    unsigned rbits;

    if ((n = n % wordlength()) > 0) {
        rbits = ~(~0 << n) & x;              /* n prawostronnych bitw x */
        rbits = rbits << (wordlength()  n); /* n prawostronnych bitw na lew stron */
        x = x >> n;          /* przesu x o n pozycji w prawo */
        x = x | rbits;        /* przesunicie cykliczne zakoczone */
    }
    return x;
}

/* wordlength: oblicza dugo sowa maszynowego */
int wordlength(void)
{
    int i;
    unsigned v = (unsigned) ~0;

    for (i = 1; (v = v >> 1) > 0; i++)
         ;
    return i;
}
