/* rightrot: przesunicie cykliczne x o n pozycji w prawo */
unsigned rightrot(unsigned x, int n)
{
    int wordlength(void);
    int rbit;                /* pierwszy bit po prawej stronie */

    while (n-- > 0) {
        rbit = (x & 1) << (wordlength()  1);
        x = x >> 1;          /* przesu x o 1 pozycj w prawo */
        x = x | rbit;        /* zakocz przesunicie cykliczne o 1 */
    }
    return x;
}

/* wordlength: oblicza dugo sowa maszynowego */
int wordlength(void)
{
    int i;
    unsigned v = (unsigned) ~0;

    for (i = 1; (v = v >> 1) > 0; i++)
         ;
    return i;
}
