#include <stdio.h>

#define MAXCOL 10              /* najwyszy numer kolumny podziau */
#define TABINC   8             /* szeroko tabulatora */

char line[MAXCOL];             /* wiersz danych wejciowych */

int exptab(int pos);
int findblnk(int pos);
int newpos(int pos);
void printl(int pos);

/* dzielenie dugich wierszy danych wejciowych */
main()
{
    int c, pos;

    pos = 0;                    /* pozycja w wierszu */
    while ((c = getchar()) != EOF) { 
        line[pos] = c;          /* zapisz biecy znak */
        if (c == '\t')          /* zastp tabulator spacjami */
            pos = exptab(pos);
        else if (c == '\n') {
            printl(pos);        /* wypisz biecy wiersz wejciowy */
            pos = 0;
        } else if (++pos >= MAXCOL) {
            pos = findblank(pos);
            printl(pos);
            pos = newpos(pos);
        }
    }
}

/* printl: wypisuje wiersz do pozycji pos */
void printl(int pos)
{
    int i;

    for (i = 0; i < pos; ++i)
        putchar(line[i]);
    if (pos > 0)                /* czy zostay wypisane jakie znaki? */
        putchar('\n');
}

/* exptab: zamienia tabulatory na spacje */
int exptab(int pos)
{
    line[pos] = ' ';            /* tabulator zastpuje co najmniej jedna spacja */
    for (++pos; pos < MAXCOL && pos % TABINC != 0; ++pos)
        line[pos] = ' ';
    if (pos < MAXCOL)           /* jest miejsce w biecym wierszu */
        return pos;
    else {                      /* biecy wiersz jest peny */
        printl(pos);
        return 0;               /* zerowanie biecej pozycji */
    }
}

/*findblnk: wyszukuje pozycj spacji */
int findblnk(int pos)
{
    while (pos > 0 && line[pos] != ' ')
        --pos;
    if (pos == 0)               /* brak spacji w wierszu? */
        return MAXCOL;
    else                        /* co najmniej jedna spacja */
        return pos+1;           /* pozycja po spacji */
}

/* newpos: zmienia pocztek wiersza */
int newpos(int pos)
{
    int i, j;

    if (pos <= 0 || pos >= MAXCOL)
        return 0;               /* nic do zmiany */
    else {
        i = 0;
        for (j = pos; j < MAXCOL; ++j) {
            line[i] = line[j];
            ++i;
        }
        return i;               /* nowa pozycja w wierszu */
    }
}
