#include  <stdio.h>

#define   MAXLINE  100     /* dopuszczalna dugo wiersza */
#define   TABINC   8       /* szeroko tabulatora */
#define   YES      1
#define   NO       0

void settab(int argc, char *argv[], char *tab);
void entab(char *tab);
int tabpos(int pos, char *tab);

/* zastpowanie cigw spacji tabulatorami i spacjami */
main(int argc, char *argv[])
{
    char tab[MAXLINE+1];

    settab(argc, argv, tab);    /* inicjalizacja pozycji tabulacji */
    entab(tab);                 /* zastpowanie spacji tabulatorami */
    return 0;
}

/* entab: zastpowanie cigw spacji tabulatorami i spacjami */
void entab(char *tab)
{
    int c, pos;
    int nb = 0;                 /* liczba wymaganych spacji */
    int nt = 0;                 /* liczba wymaganych tabulatorw */

    for (pos = 1; (c = getchar()) != EOF; ++pos) 
        if (c == ' ') {
            if (tabpos(pos, tab) == NO)
                ++nb;           /* zwiksz liczb spacji */
            else {
                nb = 0;         /* wyzeruj liczb spacji */
                ++nt;           /* jeden tabulator wicej */
            }
        } else {
            for ( ; nt > 0; nt--)        
                putchar('\t');  /* wypisz tabulator(y) */
            if (c == '\t')      /* odrzu spacj(e) */
                nb = 0;
            else                /* wypisz spacj(e) */
                for ( ; nb > 0; nb--)
                    putchar(' ');
            putchar(c);
            if (c == '\n')
                pos = 0;
            } else if (c == '\t')
                while (tabpos(pos, tab) != YES)
                    ++pos;
        }
}
