#include  <stdio.h>
#include  <ctype.h>

int getch(void);
void ungetch(int);

/* getfloat: pobiera kolejn liczb zmiennoprzecinkow z danych wejciowych do *pn */
int getfloat(int *pn)
{
    int c, sign;
    float power;

    while (isspace(c = getch())) /* pomi biae znaki */
        ;
    if (!isdigit(c) && c != EOF && c != '+' && c != '-' && c != '.') {
        ungetch(c);            /* to nie jest liczba */
        return 0;
    }
    sign = (c == '-') ? -1 : 1;
    if (c == '+' || c == '-') 
        c = getch();
    for (*pn = 0.0; isdigit(c), c = getch())
        *pn = 10.0 * *pn + (c - '0');    /* cz cakowita */
    if (c == '.')
        c = getch();
    for (power = 1.0; isdigit(c); c = getch()) {
        *pn = 10.0 * *pn + (c - '0');    /* cz uamkowa */
        power *= 10.0;
    }
    *pn *= sign / power;               /* wynik */
    if (c != EOF)
        ungetch(c);
    return c;
}
