import os.path

from django.conf.urls.defaults import *
from django.contrib import admin

admin.autodiscover()

urlpatterns = patterns('',
   (r'^admin/(.*)', admin.site.root),
   (r'^site_media/(.*)$', 'django.views.static.serve', {'document_root': os.path.join(os.path.dirname(__file__), 'site_media')}),
   (r'^news/(?P<slug>[\w\-_]+)/pdf/$', 'news.views.show_news_pdf'),
   (r'^news/(?P<slug>[\w\-_]+)/$', 'news.views.show_news'),
   (r'^ajax/$', 'news.views.ajax'),
   (r'^(?P<slug>[\w\-_]+)/$', 'news.views.news_by_category'),
   (r'^/?$', 'news.views.index'),
)
