#include <vcl.h>
#pragma hdrstop
#include "Unit_R7_02.h"
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;

//---------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
		: TForm(Owner)
{
}
//---------------------------------------------------------
void __fastcall TForm1::FormCreate(TObject *Sender)
{
  OpenDialog1->InitialDir = ExtractFilePath(ParamStr(0));
  OpenDialog1->Filter = "*.dat , *.txt, *.cpp, *.c,"
						"*.rtf | *.dat; *.txt; *.cpp;"
						" *.c; *.rtf";
  SaveDialog1->InitialDir = OpenDialog1->InitialDir;
  SaveDialog1->Filter = "*.*|*.*";
  RichEdit1->ScrollBars = ssVertical;
}
//---------------------------------------------------------
void __fastcall TForm1::CheckFileSave(void)
{
  if (RichEdit1->Modified)  {
	switch(MessageBox(NULL, "Zawarto pliku lub okna zostaa"
					" zmieniona. Zapisa zmiany?", "Uwaga!",
					MB_YESNOCANCEL | MB_ICONQUESTION))
		 {
		   case ID_YES    : FileSaveAsClick(this);
		   case ID_CANCEL : Abort();
		 };
	 }
}
//---------------------------------------------------------
void __fastcall TForm1::FileNewClick(TObject *Sender)
{
  CheckFileSave();
  RichEdit1->Lines->Clear();
  RichEdit1->Modified = FALSE;
}
//---------------------------------------------------------
void __fastcall TForm1::FileOpenClick(TObject *Sender)
{
  CheckFileSave();

  if (OpenDialog1->Execute())  {
	RichEdit1->Lines->LoadFromFile(OpenDialog1->FileName);
	RichEdit1->Modified = FALSE;
	RichEdit1->ReadOnly =
					 OpenDialog1->Options.Contains(ofReadOnly);
  }
}
//---------------------------------------------------------
void __fastcall TForm1::FileSaveAsClick(TObject *Sender)
{
  if (SaveDialog1->Execute()) {
	RichEdit1->Lines->SaveToFile(SaveDialog1->FileName);
	RichEdit1->Modified = False;
  }
}
//---------------------------------------------------------
void __fastcall TForm1::UndoClick(TObject *Sender)
{
  if (RichEdit1->HandleAllocated())
	 SendMessage(RichEdit1->Handle, EM_UNDO, 0, 0);
}
//---------------------------------------------------------
void __fastcall TForm1::CutClick(TObject *Sender)
{
  RichEdit1->CutToClipboard();
}
//---------------------------------------------------------
void __fastcall TForm1::PasteClick(TObject *Sender)
{
  RichEdit1->PasteFromClipboard();
}
//---------------------------------------------------------
void __fastcall TForm1::CopyClick(TObject *Sender)
{
  RichEdit1->CopyToClipboard();
}
//---------------------------------------------------------
void __fastcall TForm1::CloseApplicationClick(TObject *Sender)
{
  switch(MessageBox(NULL, " Dziaanie aplikacji zostanie"
	  " zakoczone.", "Uwaga!", MB_YESNOCANCEL | MB_ICONQUESTION))
	{
	  case ID_YES :	{
		  if (RichEdit1->Modified)
			 CheckFileSave();
		 Application->Terminate();
	  }
	  case ID_CANCEL : Abort();
	};
}
//---------------------------------------------------------

