using System;
namespace RobotInterpreter2
{
    /// <summary>
    /// Klasa reprezentuje ptl "while", ktrej zawarto bdzie wykonywana
    /// tak dugo, jak dugo warto zadanego terminu jest rna od null.
    /// </summary>
    public class WhileCommand : Command 
    {
        protected Term _term;
        protected Command _body;

        /// <summary>
        /// Konstrukcja polecenia "while", wykonujcego sw zawarto 
        /// tak dugo, jak dugo warto zadanego terminu jest rna od null.
        /// </summary>
        /// <param name="_term">termin sprawdzany przy kadym przebiegu ptli</param>
        /// <param name="body">wykonywana zawarto</param>
        public WhileCommand(Term term, Command body)
        {
            _term = term;
            _body = body;
        }

        /// <summary>
        /// Sprawdzenie wartoci terminu. Jeli jest ona rna od null,
        /// wykonywana jest zawarto polecenia i tak w kko.
        /// </summary>
        public override void Execute()
        {
            while (_term.Eval() != null)
            {
                _body.Execute();
            }
        }
    }
}
