using System;
using Machines;

namespace RobotInterpreter2
{
    /// <summary>
    /// Klasa reprezentuje polecenie wyczajce urzdzenie wskazywane
    /// przez dostarczony termin.
    /// </summary>
    public class ShutDownCommand : Command 
    {
        protected Term _term;

        /// <summary>
        /// Konstrukcja polecenia wyczajcego urzdzenie wskazywane
        /// przez dostarczony termin.
        /// </summary>
        /// <param name="term">termin sprawdzany w wyniku wykonania polecenia;
        /// wskazywana przez przez niego maszyna zostanie wyczona</param>
        public ShutDownCommand(Term term)
        {
            _term = term;
        }

        /// <summary>
        /// Okrela maszyn wskazywan przez termin i wycza j.
        /// </summary>
        public override void Execute()
        {
            Machine m = _term.Eval();
            m.ShutDown();
        }
    }
}
