using System;
namespace RobotInterpreter2
{
    /// <summary>
    /// Klasa reprezentuje wyraenie warunkowe, wykonujce jedno z dwch
    /// polece w zalenoci od wartoci dostarczonego terminu.
    /// </summary>
    public class IfCommand : Command 
    {
        protected Term _term;
        protected Command _body;
        protected Command _elseBody;

        /// <summary>
        /// Konstrukcja polecenia "if" wykonujcego swoj zawarto "else"
        /// jeli wartoci dostarczonego terminu jest null, w przeciwnym
        /// przypadku wykonujcego swoj zwyk zawarto.
        /// </summary>
        /// <param name="term">termin sucy do ustalenia zawartoci do
        /// wykonania</param>
        /// <param name="body">zawarto wykonywana jeli termin jest prawd</param>
        /// <param name="elseBody">zawarto wykonywana jeli termin jest faszem</param>
        public IfCommand(Term term, Command body, Command elseBody)
        {
            _term = term;
            _body = body;
            _elseBody = elseBody;
        }

        /// <summary>
        /// Wykonuje zawarto "else" obiektu, jeli wartoci terminu jest 
        /// null. W przeciwnym razie wykonuje zawarto gwn.
        /// </summary>
        public override void Execute()
        {
            if (_term.Eval() != null)
            {
                _body.Execute();
            }
            else
            {
                _elseBody.Execute();
            }
        }
    }
}
