using System;
using Machines;
namespace RobotInterpreter2
{
    /// <summary>
    /// Obsuga przeniesienia pojemnika z jednej maszyny do drugiej,
    /// z moliwoci odwoywania si do maszyn wedug terminw.
    /// </summary>    
    public class CarryCommand : Command 
    {
        protected Term _from;
        protected Term _to;

        /// <summary>
        /// Konstrukcja polecenia przeniesienia pojemnika z jednej
        /// maszyny do drugiej.
        /// </summary>
        /// <param name="fromTerm">zmienna lub staa wskazujca maszyn,
        /// z ktrej ma by odebrany pojemnik</param>
        /// <param name="toTerm">zmienna lub staa wskazujca maszyn,
        /// przy ktrej ma by postawiony pojemnik</param>
        public CarryCommand(Term fromTerm, Term toTerm)
        {
            _from = fromTerm;
            _to = toTerm;
        }

        /// <summary>
        /// Przeksztaca terminy na konkretne maszyny i przenosi
        /// pojemnik midzy odpowiednimi maszynami.
        /// </summary>
        public override void Execute()
        {
            Robot.singleton.Carry(_from.Eval(), _to.Eval());
        }
    }
}
