using System;
namespace Processes
{
    /// <summary>
    /// Interfejs definiuje typ obiektu akceptowanego przez etapy i kompozyty
    /// procesw. Klasy hierarchii ProcessComponent odwouj si z powrotem do
    /// metod Visit() obiektu-gocia, identyfikujc zarazem swj typ. Klasy
    /// implementujce ten interfejs mog dostarcza rne algorytmy dla
    /// rnych typw komponentw procesu. 
    /// </summary>
    public interface IProcessVisitor 
    {
        /// <summary>
        /// Odwiedzenie alternacji procesu.
        /// </summary>
        /// <param name="a">odwiedzana alternacja procesu</param>
        void Visit(ProcessAlternation a);
        /// <summary>
        /// Odwiedzenie sekwencji procesw.
        /// </summary>
        /// <param name="s">odwiedzana sekwencja procesw</param>
        void Visit(ProcessSequence s);
        /// <summary>
        /// Odwiedzenie etapu procesu.
        /// </summary>
        /// <param name="s">odwiedzany etap procesu</param>
        void Visit(ProcessStep s);
    }
}
