using System;
namespace Functions
{
    /// <summary>
    /// Opakowuje funkcj Math.Exp() wok dostarczonego rda.
    /// </summary>
    public class Exp : Frapper 
    {
        /// <summary>
        /// Konstrukcja funkcji wykadniczej opakowujcej podan funkcj
        /// rdow.
        /// </summary>
        /// <param name="f">Inna klasa opakowujca funkcj</param>
        public Exp(Frapper f) : base (f)
        {
        }
        /// <summary>
        /// Zwraca wynik wykonania Math.Exp() dla wartoci funkcji rdowej
        /// w momencie t.
        /// </summary>
        /// <param name="t">czas</param>
        /// <returns>Math.E podniesione do potgi wartoci funkcji rdowej
        /// w momencie t</returns>
        public override double F(double t)
        {
            return Math.Exp(_sources[0].F(t));
        }
    }
}
