using System;
namespace Functions
{
    /// <summary>
    /// Dostarcza "funkcj" ignorujc parametr czasu t i zawsze zwracajc
    /// sta warto.
    /// </summary>
    public class Constant : Frapper 
    {
        protected double _constant;
        /// <summary>
        /// Konstrukcja "funkcji" ignorujcej parametr czasu t i zawsze 
        /// zwracajcej sta warto.
        /// </summary>
        /// <param name="constant">sta</param>
        public Constant(double constant) : base (new Frapper[]{})
        {
            _constant = constant;
        }
        /// <summary>
        /// Zwraca sta warto tego obiektu.
        /// </summary>
        /// <param name="t">czas, ignorowany</param>
        /// <returns>sta warto tego obiektu</returns>
        public override double F(double t)
        {
            return _constant;
        }
    }
}
