using System;
namespace Filters
{
    /// <summary>
    /// Filtr zmieniajcy wielko otrzymywanych znakw tak, by kady znak
    /// pisany po biaym znaku by wielk liter.
    /// </summary>
    public class TitleCaseFilter : OozinozFilter 
    {
        protected bool inWhite = true;
        /// <summary>
        /// Konstrukcja filtra przekazujcego znaki odpowiedniej wielkoci
        /// do wskazanego obiektu piszcego.
        /// </summary>
        /// <param name="writer">docelowy obiekt piszcy</param>
        public TitleCaseFilter(ISimpleWriter writer) : base (writer)
        {
        }  
        
        /// <summary>
        /// Przekazuje otrzymany znak o odpowiedniej wielkoci do strumienia
        /// bazowego.
        /// </summary>
        /// <param name="c">znak</param>
        public override void Write(char c) 
        {
            _writer.Write(inWhite
                ? Char.ToUpper(c)
                : Char.ToLower(c));
            inWhite = Char.IsWhiteSpace(c) || c == '\"';
        }
        /// <summary>
        /// Przesonicie tej metody tylko po to, by zaznaczy, e
        /// powoduje ona powrt do biaych znakw.
        /// </summary>
        public override void WriteLine()
        {
            base.WriteLine();
            inWhite = true;
        }
    }
}
