using System;
namespace Filters
{
    /// <summary>
    /// Klasa obsugujca mechanizm przekazywania wywoa metody Write() filtrowi
    /// wewntrznemu, wymagajca podania w konstruktorze innego filtra. Klasa
    /// implementuje rwnie metod Write(string), wymagan przez interfejs
    /// ISimpleWriter. Metoda Write(char) pozostaje jednak abstrakcyjna, gdy t 
    /// wanie metod klasy potomne bd implementowa na rne ciekawe sposoby.
    /// </summary>
    public abstract class OozinozFilter : ISimpleWriter 
    {
        protected ISimpleWriter _writer;

        /// <summary>
        /// Konstrukcja filtra przekazujcego znaki do wskazanego strumienia.
        /// </summary>
        /// <param name="writer">docelowy obiekt piszcy</param>
        public OozinozFilter(ISimpleWriter writer) 
        {
            _writer = writer;
        }  
        /// <summary>
        /// Przekazanie dania strumieniowi potomnemu.
        /// </summary>
        public abstract void Write(char c);

        /// <summary>
        /// Zapisuje cig znakw, przekazujc go strumieniowi potomnemu.
        /// </summary>
        /// <param name="s">zapisywany cig znakw</param>
        public virtual void Write(string s)
        {
            foreach(char c in s.ToCharArray())
            {
                Write(c);
            }
        }
        /// <summary>
        /// Wstawienie znaku nowej linii.
        /// </summary>
        public virtual void WriteLine()
        {
            _writer.WriteLine();
        }
        /// <summary>
        /// Zamknicie filtra wewntrznego.
        /// </summary>
        public virtual void Close()
        {
            _writer.Close();
        }
    }
}
