using System;
namespace Filters
{
    /// <summary>
    /// Filtr zamieniajcy przetwarzane znaki na mae.
    /// </summary>
    public class LowerCaseFilter : OozinozFilter 
    {
        /// <summary>
        /// Konstrukcja filtra przekazujcego mae znaki do wskazanego
        /// strumienia.
        /// </summary>
        /// <param name="writer">docelowy obiekt piszcy</param>
        public LowerCaseFilter(ISimpleWriter writer) : base (writer)
        {
        }  
        
        /// <summary>
        /// Przekazuje ma wersj podanego znaku do strumienia podstawowego.
        /// </summary>
        /// <param name="c">znak</param>
        public override void Write(char c) 
        {
            _writer.Write(char.ToLower(c));
        }
    }
}
