using System;
using Credit;
namespace Credit.Canada
{
    /// <summary>
    /// Fabryka obiektw do sprawdzania zdolnoci kredytowej, adresw do
    /// fakturowania i adresw wysyki w Kanadzie.
    /// </summary>
    public class CheckFactoryCanada : CreditCheckFactory 
    {
        /// <summary>
        /// Zwraca obiekt implementujcy IBillingCheck dla klientw kanadyjskich.
        /// </summary>
        /// <returns>obiekt implementujcy IBillingCheck dla klientw kanadyjskich</returns>
        public override IBillingCheck CreateBillingCheck()
        {
            return new BillingCheckCanada();
        } 
        /// <summary>
        /// Zwraca obiekt implementujcy ICreditCheck dla klientw kanadyjskich.
        /// </summary>
        /// <returns>obiekt implementujcy ICreditCheck dla klientw kanadyjskich</returns>
        public override ICreditCheck CreateCreditCheck2()
        {
            if (IsAgencyUp())
            {
                return new CreditCheckCanadaOnline();
            }
            else
            {
                return new CreditCheckOffline();
            }
        } 
        /// <summary>
        /// Zwraca obiekt implementujcy IShippingCheck dla klientw kanadyjskich.
        /// </summary>
        /// <returns>obiekt implementujcy IShippingCheck dla klientw kanadyjskich</returns>
        public override IShippingCheck CreateShippingCheck()
        {
            return new ShippingCheckCanada();
        }
    }
}
