using System;

namespace Controllers
{
	/// <summary>
	/// Przykad z rozdziau Bridge. Jest to klasa abstrakcyjna, a zarazem
	/// przykad abstrakcji - klasy zawierajcej metody konkretne zalene
	/// od metod abstrakcyjnych.
	/// </summary>
	public abstract class MachineManager
    {
        public abstract void StartMachine();
        public abstract void StopMachine();
        public abstract void StartProcess();
        public abstract void StopProcess();
        public abstract void ConveyIn();
        public abstract void ConveyOut();
        public void Shutdown() 
        {
            StopProcess();
            ConveyOut();
            StopMachine();
        }
	}
}
