using System; 

namespace Chemicals
{
    /// <summary>
    /// Klasa reprezentujca zwizek chemiczny.
    /// </summary>
    public class Chemical
    {
        private String _name;
        private String _symbol;
        private double _atomicWeight;

        /// <summary>
        /// Modeluje zwizek chemiczny, na przykad saletr.
        /// </summary>
        /// <param name="name">Nazwa zwizku, na przykad "Saletra".</param>
        /// <param name="symbol">Wzr chemiczny zwizku, na przykad "KNO3".</param>
        /// <param name="atomicWeight">Masa atomowa zwizku (dla saletry byoby to 101).</param>
        internal Chemical(
            String name,
            String symbol,
            double atomicWeight)
        {
            _name = name;
            _symbol = symbol;
            _atomicWeight = atomicWeight;
        }
        /// <summary>
        /// Nazwa zwizku, na przykad "Saletra".
        /// </summary>
        public string Name
        {
            get
            {
                return _name;
            }
        }
        /// <summary>
        /// Wzr chemiczny zwizku, na przykad "KNO3".
        /// </summary>
        public string Symbol
        {
            get
            {
                return _symbol;
            }
        }
        /// <summary>
        /// Masa atomowa zwizku (dla saletry byoby to 101).
        /// </summary>
        public double AtomicWeight
        {
            get
            {
                return _atomicWeight;
            }
        }
        /// <summary>
        /// Opis zwizku chemicznego.
        /// </summary>
        /// <returns>tekstowy opis zwizku</returns>
        public override String ToString()
        {
            return _name + "(" + _symbol + ")[" + _atomicWeight + "]";
        }
    }
}
