using System;

namespace Carousel2
{
	/// <summary>
	/// Przeksztacona wersja klasy z pierwotnej przestrzeni nazw Carousel.
	/// W tym przypadku obiekt drzwi jest przekazywany midzy stanami,
	/// podczas gdy poprzednio wszystkie stany odwoyway si do konkretnego
   /// obiektu drzwi.
	/// </summary>
	public abstract class DoorState
	{
        public static readonly DoorState CLOSED   = new DoorClosed();
        public static readonly DoorState OPENING  = new DoorOpening();
        public static readonly DoorState OPEN     = new DoorOpen();
        public static readonly DoorState CLOSING  = new DoorClosing();
        public static readonly DoorState STAYOPEN = new DoorStayOpen();

        /// <summary>
        /// Klasy potomne musz same zdecydowa o dziaaniu podejmowanym
        /// w chwili nacinicia przycisku karuzeli przez uytkownika.
        /// </summary>
        public abstract void Touch(Door door);

        /// <summary>
        /// Powiadomienia o zakoczeniu otwierania lub zamykania drzwi s
        /// domylnie ignorowane.
        /// </summary>
        public virtual void Complete(Door door)
        {
        }

        /// <summary>
        /// Powiadomienia o rozpoczciu zamykania z powodu przekroczenia
        /// czasu otwarcia s domylnie ignorowane.
        /// </summary>
        public virtual void Timeout(Door door)
        {
        }

        /// <summary>
        /// Zwraca tekstowy opis biecego stanu.
        /// </summary>
        /// <returns>tekstowy opis biecego stanu</returns>
        public String Status()
        {
            return this.GetType().Name;
        }
	}    
}
