using System;

namespace Carousel2
{
    /// <summary>
    /// Przeksztacona wersja klasy Door. Logika obsugi stanu drzwi
    /// zostaa umieszczona w osobnej hierarchii klas.
    /// </summary>
    public class Door
    {
        public ChangeHandler Change;
        private DoorState _state; 

        /// <summary>
        /// Inicjalizacja biecych drzwi.
        /// </summary>
        public Door()
        {
            _state = DoorState.CLOSED;
        }

        /// <summary>
        ///  Uytkownik karuzeli nacisn jej przycisk. Jest to przycisk
        ///  wielofunkcyjny, a jego zachowanie zaley od biecego stanu
        ///  drzwi.
        /// </summary>
        public void Touch()
        {
            _state.Touch(this);
        }

        /// <summary>
        /// Powiadomienie od fizycznej karuzeli, e zakoczyo si 
        /// otwieranie lub zamykanie jej drzwi.
        /// </summary>
        public void Complete()
        {
            _state.Complete(this);
        }

        internal void SetState(DoorState state)
        {
            this._state = state;
            if (Change != null) Change();
        }

        /// <summary>
        /// Zwraca tekstowy opis biecego stanu drzwi.
        /// </summary>
        /// <returns>tekstowy opis biecego stanu drzwi</returns>
        public String Status()
        {
            return _state.Status();
        }

        /// <summary>
        /// Powiadomienie od fizycznej karuzeli, e tolerowany czas otwarcia
        /// drzwi min.
        /// </summary>
        public void Timeout()
        {
            _state.Timeout(this);
        }
    }
}
