namespace Carousel
{
    /// <summary>
    /// Klasa modeluje zachowanie otwierajcych si drzwi karuzeli.
    /// </summary>
    public class DoorOpening : DoorState 
    {
        /// <summary>
        /// Konstrukcja stanu dostarczonych drzwi.
        /// </summary>
        /// <param name="door">drzwi wymagajce modelu stanu</param>
        public DoorOpening(Door2 door) : base (door)
        {
        }

        /// <summary>
        /// Otwieranie zostao zakoczone, wic drzwi s otwarte.
        /// </summary>
        public override void Complete()
        {
            _door.SetState(_door.OPEN);
        }

        /// <summary>
        /// Zamykanie drzwi po naciniciu przycisku.
        /// </summary>
        public override void Touch()
        {
            _door.SetState(_door.CLOSING);
        }
    }
}
