namespace Aster 
{
    /// <summary>
    /// Klasa sterujca fikcyjn pras gwiazdow Aster i wspomagajca
    /// komunikacj z fabryk, w ktrej prasa si znajduje. W rzeczywistoci
    /// klasa jest pretekstem do pokazania sposobu, w ktry klient mgby
    /// dostarczy metod szablonow.
    /// 
    /// Klasa jest opisana w rozdziale Template Method.
    /// </summary>
    public abstract class AsterStarPress 
    {
        protected int _currentMoldID;

        /// <summary>
        /// Wyrzuca ca past uywan do tworzenia gwiazd do mietnika.
        /// </summary>
        public virtual void DischargePaste()
        {
        }

        /// <summary>
        /// Zlanie wod powierzchni roboczej i dysz z past w celu utrzymania
        /// czystoci maszyny.
        /// </summary>
        public virtual void Flush()
        {
        }

        /// <summary>
        /// Zwraca true jeli maszyna aktualnie przetwarza form.
        /// </summary>
        /// <returns>true jeli maszyna aktualnie przetwarza form</returns>
        public virtual bool InProcess()
        {
            return false;
        }

        /// <summary>
        /// Konkretny sposb radzenia sobie przez fabryk z niekompletnie
        /// przetworzon form zostanie zaimplementowany w klasach
        /// dziedziczcych.
        /// </summary>
        /// <param name="id">identyfikator niekompletnej formy</param>
        public abstract void MarkMoldIncomplete(int id);

        /// <summary>
        /// Wstrzymanie przetwarzania, oznaczenie biecej formy jako 
        /// niekompletnej, usunicie z maszyny wszystkich form, wyrzucenie
        /// przygotowanej pasty i zlanie powierzchni roboczej wod.
        /// </summary>
        public virtual void ShutDown()
        {
            if (InProcess())
            {
                StopProcessing();
                MarkMoldIncomplete(_currentMoldID);
            }
            UsherInputMolds();
            DischargePaste();
            Flush();
        }

        /// <summary>
        /// Wstrzymanie przetwarzania.
        /// </summary>
        public virtual void StopProcessing()
        {
        }

        /// <summary>
        /// Przesunicie wszystkich form na tam wyjciow.
        /// </summary>
        public virtual void UsherInputMolds()
        {
        }
    }
}
