using System;
using System.Data;
using DataLayer;

/// <summary>
/// Demonstracja przechwycenia dania do obiektu czytajcego dane.
/// </summary>
public class LimitingReader : DataReaderProxy
{
    /// <summary>
    /// Przechwycenie obiektu
    /// </summary>
    /// <param name="subject">zastpowany przez porednika obiekt czytajcy</param>
    public LimitingReader(IDataReader subject) : base (subject)
    {
    }
    /// <summary>
    /// Pokazuje przykadowe przechwycenie dania danych o apogeum rakiety.
    /// </summary>
    public override object this [string name]
    {
        get
        {
            if (String.Compare(name, "apogee", true) == 0)
            {
                return 0;
            }
            else 
            {
                return base [name];
            }
        }
    }
}