using System;
using Functions;
using UserInterface;

/// <summary>
/// Klasa dziedziczca z PlotPanel, nasuchujca zdarze Change
/// pochodzcych z obiektu TpeakFunction.
/// </summary>
public class AlertPlotPanel : PlotPanel
{
    /// <summary>
    /// Tworzy nasuchujcy zmian panel wykresu.
    /// </summary>
    /// <param name="nPoint">ilo nanoszonych punktw</param>
    /// <param name="tf">nanoszona funkcja</param>
    public AlertPlotPanel(int nPoint, TpeakFunction tf) : 
        base (nPoint, new Function(tf.F))
    {
        tf.Change += new EventHandler(FunctionChange);
    }
    private void FunctionChange(object sender, EventArgs e)
    {
        Refresh();
    }
}