using System;

namespace Simulation
{
    /// <summary>
    /// Instancje tej klasy symuluj rakiety. Symulacja obejmuje przede
    /// wszystkim zachowanie spalanego paliwa.
    /// </summary>
    public class Skyrocket
    {
        private double _mass;
        private double _thrust;
        private double _burnTime;
        protected double _simTime;

        /// <summary>
        /// Tworzy model rakiety.
        /// </summary>
        /// <param name="mass">pocztkowa masa rakiety</param>
        /// <param name="thrust">pocztkowy cig rakiety</param>
        /// <param name="burnTime">czas spalania paliwa rakiety</param>
        public Skyrocket (
            double mass, double thrust, double burnTime) 
        {
            _mass = mass;
            _thrust = thrust;
            _burnTime = burnTime;
        }

        /// <summary>
        /// Model masy polegajcy na jej liniowej redukcji do zera przez 
        /// cay czas istnienia paliwa.
        /// </summary>
        /// <returns>mas</returns>
        public virtual double GetMass()   
        {
            if (_simTime > _burnTime) return 0;            
            return _mass * (1 - (_simTime / _burnTime));
        }

        /// <summary>
        /// Model cigu jako wartoci staej przez cay czas istnienia paliwa.
        /// </summary>
        /// <returns>cig</returns>
        public virtual double GetThrust()  
        {
           if (_simTime > _burnTime) return 0;   
           return _thrust;
        }

        /// <summary>
        /// Zapisanie czasu w momencie aktualizacji zegara symulacji.
        /// </summary>
        /// <param name="t">czas symulacji</param>
        public virtual void SetSimTime(double t)
        {
            _simTime = t;
        }
    }
}
