namespace Simulation 
{
    /// <summary>
    /// Definicja interfejsu uywanego przez nasz symulator do modelowania
    /// osigw rakiet.
    /// </summary>
    public interface IRocketSim
    {
        /// <summary>
        /// Zwraca mas symulowanej rakiety (w kilogramach) w okrelonym
        /// momencie.
        /// </summary>
        /// <returns>mas rakiety w okrelonym momencie</returns>
        double GetMass();
        /// <summary>
        /// Zwraca cig (w niutonach na sekund) generowany przez symulowan
        /// rakiet.
        /// </summary>
        /// <returns>Cig w niutonach na sekund</returns>
        double GetThrust();
        /// <summary>
        /// Aktualizacja czasu symulacji na podstawie zegara symulacji.
        /// </summary>
        /// <param name="t">biecy czas zegara symulacji</param>
        void SetSimTime(double t);
    }
}