using System;
using Machines;

namespace RobotInterpreter2
{
    /// <summary>
    /// Reprezentuje stan, w ktrym na maszynie (dostpnej za porednictwem
    /// terminu) znajduje si materia.
    /// </summary>
    public class HasMaterial : Term 
    {
        protected Term _term;

        /// <summary>
        /// Konstrukcja terminu reprezentujcego funkcj boolowsk okrelajc,
        /// czy termin odwouje si do maszyny posiadajcej materia.
        /// </summary>
        /// <param name="term">termin do sprawdzenia (na og zmienna lub maszyna)</param>
        public HasMaterial(Term term)
        {
            _term = term;
        }

        /// <summary>
        /// Zwraca null jeli termin potomny dotyczy maszyny nieposiadajcej
        /// materiau.
        /// </summary>
        /// <returns>null jeli termin potomny dotyczy maszyny nieposiadajcej
        /// materiau. W przeciwnym razie zwraca maszyn.</returns>
        public override Machine Eval()
        {
            Machine m = _term.Eval();
            return m.HasMaterial() ? m : null;
        }
    }
}
