using System;
using System.Collections;
using Machines;
namespace RobotInterpreter2
{
    /// <summary>
    /// Klasa odpowiada ptli "for", wykonujcej sw zawarto dla kadej
    /// maszyny w ramach dostarczonego kompozytu. W kadym przebiegu 
    /// ptli, zmienna jest przypisywana innej maszynie.
    /// </summary>
    public class ForCommand : Command 
    {
        protected MachineComponent _root;
        protected Variable _variable;
        protected Command _body;

        /// <summary>
        /// Konstrukcja interpretera "for", wykonujcego dostarczon 
        /// zawarto ptli, przechodzcemu po kolejnych maszynach w danym
        /// kontekcie i przypisujcego kadej maszynie dostarczon zmienn.
        /// </summary>
        /// <param name="root">komponent maszyn do iterowania</param>
        /// <param name="v">zmienna ustawiana w ramach ptli</param>
        /// <param name="body">zawarto ptli</param>
        public ForCommand(MachineComponent mc, Variable v, Command body)
        {
            _root = mc;
            _variable = v;
            _body = body;
        }

        /// <summary>
        /// Dla kadej maszyny w danym kontekcie, przypisz zmienn obiektu
        /// do maszyny i wykonaj zawarto obiektu (czyli ptl).
        /// </summary>
        public override void Execute()
        {
            Execute(_root);
        } 
        private void Execute(MachineComponent mc) 
        {
            Machine m = mc as Machine;
            if (m != null)
            {
                _variable.Assign(new Constant(m));
                _body.Execute();
                return;
            }
            MachineComposite comp = mc as MachineComposite;
            foreach (MachineComponent child in comp.Children)
            {
                Execute(child);
            }
        } 
    }
}
