using System;
using Machines;

namespace RobotInterpreter2
{
    /// <summary>
    /// Odpowiada porwnaniu dwch terminw.
    /// </summary>
    public class Equals : Term 
    {
        protected Term _term1;
        protected Term _term2;
              
        /// <summary>
        /// Konstrukcja terminu pozwalajcego porwna dwa dostarczone terminy.
        /// </summary>
        /// <param name="term1">pierwszy termin do porwnania</param>
        /// <param name="term2">drugi termin do porwnania</param>
        public Equals(Term term1, Term term2)
        {
            this._term1 = term1;
            this._term2 = term2;
        }

        /// <summary>
        /// Zwraca null jeli terminy potomne odwouj si do rnych maszyn.
        /// </summary>
        /// <returns>null jeli terminy potomne odwouj si do rnych 
        /// maszyn. W przeciwnym razie zwraca maszyn.</returns>
        public override Machine Eval()
        {
            Machine m1 = _term1.Eval();
            Machine m2 = _term2.Eval();
            bool b = m1.Equals(m2);
            return b ? m1 : null;
        }
    }
}
