using System;
namespace RobotInterpreter
{
    /// <summary>
    /// Klasa abstrakcyjna reprezentujca hierarchi klas odpowiadajcych
    /// poleceniom. Obiekt polecenia to operacja, ktra jest wykonywane
    /// dopiero wtedy, gdy obiekt wywoujcy tego zada.
    /// 
    /// Klasy potomne najczciej odpowiadaj jakiej podstawowej funkcji
    /// i dopuszczaj parametry dostrajajce polecenie dla konkretnego celu.
    /// Wszystkie klasy polece musz implementowa metod Execute(), ktra
    /// tutaj jest abstrakcyjna.
    /// </summary>
    public abstract class Command 
    {
        /// <summary>
        /// Wykonanie dania ujtego w tym poleceniu.
        /// </summary>
        public abstract void Execute();
    }
}
