using System;
using Fireworks;
namespace Recommendations
{
    /// <summary>
    /// Implementacja interfejsu Advisor korzystajca z systemu Rel8,
    /// porwnujcego preferencje klienta z upodobaniami innych klientw.
    /// </summary>
    public class GroupAdvisor : Advisor 
    {
        public static readonly GroupAdvisor singleton = new GroupAdvisor();

        private GroupAdvisor()
        {
        }

        /// <summary>
        /// Polecenie klientowi odpowiedniego produktu, wybranego na podstawie
        /// porwnania upodoba klienta w kwestii muzyki i sportw ekstremalnych
        /// z preferencjami i ulubionymi fajerwerkami innych klientw.
        /// </summary>
        /// <param name="c">profilowany klient</param>
        /// <returns>odpowiedni produkt dla tego klienta</returns>
        public Firework Recommend(Customer c)
        {
            return (Firework) Rel8.Advise(c);
        }
    }
}
