using System;
using System.IO;
//using System.Xml;
using System.Xml.Serialization;
using Fireworks;
using Utilities;
 
namespace Recommendations
{
    /// <summary>
    /// Modeluje klienta.
    /// </summary>
    public class Customer 
    {
        private Advisor _advisor;
        public static readonly int BIG_SPENDER_DOLLARS = 1000;

        /// <summary>
        /// Zwraca true jeli klient zarejestrowa swj profil preferencji.
        /// </summary>
        /// <returns>true jeli klient zarejestrowa swj profil preferencji.
        /// Metoda nie jest zaimplementowana.</returns>
        public bool IsRegistered()
        {
            return false;
        }

        /// <summary>
        /// W poniszy sposb upewniam si, e korzystam z waciwego
        /// pliku zawierajcego strategiczn promocj. Jeli do systemowej
        /// cieki klas (classpath) dodasz katalog "oozinoz" z tymi przykadami,
        /// ten program odnajdzie plik strategy.xml zawierajcy dane promowanego
        /// fajerwerku. Krtko mwic, jest to przykad znalezienia
        /// i wczytania pliku waciwoci.
        /// </summary>
        public static void Main() 

        {
            new Customer().GetRecommended();
        }

        /// <summary>
        /// Zwraca sum wydatkw klienta w Oozinoz od podanej daty.
        /// </summary>
        /// <param name="date">Data pocztkowa</param>
        /// <returns>sum wydatkw klienta w Oozinoz od podanej daty;
        /// metoda nie jest zaimplementowana.
        /// </returns>
        public double SpendingSince(DateTime date)
        {
            return 1000;
        }


        private Advisor GetAdvisor()
        {
            if (_advisor == null)
            {
                if (PromotionAdvisor.singleton.HasItem())
                {
                    _advisor = PromotionAdvisor.singleton;
                }
                else if (IsRegistered())
                {
                    _advisor = GroupAdvisor.singleton;
                }
                else if (IsBigSpender())
                {
                    _advisor = ItemAdvisor.singleton;
                }
                else
                {
                    _advisor = RandomAdvisor.singleton;
                }
            }
            return _advisor;
        }

        /// <summary>
        /// Zwraca fajerwerk polecany klientowi.
        /// </summary>
        /// <returns>fajerwerk polecany klientowi</returns>
        public Firework GetRecommended()
        {
            // jeli promowany jest konkretny fajerwerk, naley do zwrci
            try
            {
                String s = FileFinder.GetFileName("config", "strategy.xml");
                StreamReader r = new StreamReader(s);
                XmlSerializer xs = new XmlSerializer(typeof(String));
                String promotedName = (String) xs.Deserialize(r);
                r.Close();

                Firework f = Firework.Lookup(promotedName);
                if (f != null)
                {
                    return f;
                }
            }
            catch {}

            // jeli klient jest zarejestrowany, trzeba go porwna z innymi
            if (IsRegistered())
            {
                return (Firework) Rel8.Advise(this);
            }
            // sprawdzenie wydatkw z ubiegego roku
            if (SpendingSince(DateTime.Now.AddYears(-1)) > 1000)
            {
                return (Firework) LikeMyStuff.Suggest(this);
            }
            // trudno - bdzie losowy
            return Firework.GetRandom();
        }

        /// <summary>
        /// Zwraca fajerwerk polecany klientowi.
        /// </summary>
        /// <returns>fajerwerk polecany klientowi. Metoda przeksztacona do
        /// wzorca Strategy.</returns>
        public Firework GetRecommended_2()
        {
            return GetAdvisor().Recommend(this);
        }

        private bool IsBigSpender()
        {
            return SpendingSince(DateTime.Now.AddYears(-1)) > BIG_SPENDER_DOLLARS;
        }
    }
}
