using System;
using System.Collections;
using Enumerators;
using Utilities;
namespace Processes
{
    /// <summary>
    /// Reprezentuje pojedynczy etap procesu.
    /// </summary>
    public class ProcessStep : ProcessComponent 
    {
        /// <summary>
        /// Tworzy etap o zadanej nazwie.
        /// </summary>
        /// <param name="name">nazwa etapu procesu</param>
        public ProcessStep(String name) : base(name)
        {
        }
        /// <summary>
        /// Zaczep pozwalajcy gociom dodawa operacje do kompozytu procesw.
        /// Chodzi o to, by odwoa si z powrotem do gocia wskazujc 
        /// jednoczenie typ wza, czyli ProcessStep.
        /// </summary>
        /// <param name="v"></param>
        public override void Accept(IProcessVisitor v)
        {
            v.Visit(this);
        }
        /// <summary>
        /// Zwraca enumerator, ktry po prostu zwrci biecy etap.
        /// </summary>
        /// <param name="visited">zbir odwiedzonych wzw</param>
        /// <returns>enumerator, ktry po prostu zwrci biecy etap</returns>
        public override ComponentEnumerator GetEnumerator(Set visited)
        {
            return new LeafEnumerator(this, visited);
        }
        /// <summary>
        /// Zwraca liczb etapw w ramach biecego etapu, czyli 1.
        /// </summary>
        /// <param name="visited">komponenty odwiedzone podczas przechodzenia
        /// biecego komponentu</param>
        /// <returns>1, czyli liczb etapw w tym etapie</returns>
        public override int GetStepCount(Hashtable visited)
        {
            visited.Add(_name, this);
            return 1;
        }
    }
}
