using System;
using System.Collections;

namespace Processes
{
    /// <summary>
    /// Reprezentuje sekwencj etapw procesu.
    /// </summary>
    public class ProcessSequence : ProcessComposite 
    {
        /// <summary>
        /// Tworzy sekwencj o zadanej nazwie.
        /// </summary>
        /// <param name="name">nazwa sekwencji procesw</param>
        public ProcessSequence(String name) : base(name)
        {
        }
        /// <summary>
        /// Tworzy sekwencj o zadanej nazwie, zawierajc zadane podprocesy.
        /// </summary>
        /// <param name="name">nazwa sekwencji</param>
        /// <param name="subprocesses">podprocesy sekwencji</param>
        public ProcessSequence(
            String name, params ProcessComponent[] subprocesses) : 
            base(name, subprocesses)
        {
        }
        /// <summary>
        /// Tworzy sekwencj o zadanej nazwie, zawierajc zadane podprocesy.
        /// </summary>
        /// <param name="name">nazwa sekwencji</param>
        /// <param name="subprocesses">podprocesy sekwencji</param>
        public ProcessSequence(String name, IList subprocesses) : 
            base(name, subprocesses)
        {
        }
        /// <summary>
        /// Zaczep pozwalajcy gociom dodawa operacje do kompozytu procesw.
        /// Chodzi o to, by odwoa si z powrotem do gocia wskazujc 
        /// jednoczenie typ wza, czyli ProcessAlternation.
        /// ProcessSequence.
        /// </summary>
        /// <param name="v"></param>
        public override void Accept(IProcessVisitor v)
        {
            v.Visit(this);
        }
    }
}
